<?php

	$netim_infos="Additional information";
	$netim_rules="Rules";
	$netim_caution="Caution";
	$netim_agreement="Agreement";
	$netim_agreement_rules="I confirm I meet eligibility criterias.";
	$netim_agreement_rules2="I agree this rule.";
	$netim_agreement_rules3="I understand.";
	$netim_agreement_trustee="I agree and I confirm my wish to register this domain name using the trustee service.";
	$netim_freetrustee="For some reasons, this extension is only available using our proxy service which is already included into the pricing. Thus, our local contact will be defined as registrant on your behalf in order to fulfill the rules.";
	
	$netim_mandatory_ind = "Mandatory for individuals";
	$netim_mandatory_org = "Mandatory for legal entities";
	$netim_date_format = "Expected format: DD-MM-YYYY";
	//---
	$netim_aero_rules=".AERO domains are restricted to people, organizations, associations and agencies linked to the aeronautic and aerospatial activities. <a href='https://www.information.aero/registration/eligibility' target='blank'>More information about eligibility criteria</a>.";
	$netim_aero_id=".AERO ID";
	$netim_aero_id_description="If you do not have an ID yet, <a href='https://www.information.aero/node/add/request-aero-id' target='blank'>you can request an ID here</a>. Please note that the registration will be postponed until your application is approved by the registry.";
	$netim_aero_password=".AERO ID password";
	$netim_aero_infos=$netim_aero_id_description;
	//---
	$netim_al_registrant_type="Registrant's type";
	$netim_al_registrant_org_al="Legal entity in Albania";
	$netim_al_registrant_org_eu="Legal entity in European Union";
	$netim_al_registrant_org_other="Legal entity (other countries)";
	$netim_al_registrant_ind="Individual (whatever country)";
	$netim_al_infos=".AL domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_al_registrant_ind</strong>: provide the ID card or passport number</li>
            <li><strong>$netim_al_registrant_org_al</strong>: provide the VAT number and ID card or passport number of legal representative</li>
            <li><strong>$netim_al_registrant_org_eu</strong>: provide the registration and the E.U. VAT number</li>
            <li><strong>$netim_al_registrant_org_other</strong>: provide the registration number and ID card or passport number of legal representative</li>
        </ul>";
	$netim_al_companynumber = "Legal entity registration number";
	$netim_al_companynumber_description = "$netim_mandatory_org outside Albania";
	$netim_al_vatnumber = "Legal entity VAT number";
	$netim_al_vatnumber_description = "$netim_mandatory_org in Albania or E.U.";
	$netim_al_idcardnumber = "Personal ID card number";
	$netim_al_passportnumber = "Personal Passport number";
	$netim_al_id_description = "In all cases, provide either ID card number either Passport number of legal representative";
	$netim_al_rules_2LVL="Third level domain under .AL extension are restricted to legal entities registered in Albania.";
	$netim_al_infos_2LVL="Provide the registration number and ID card or passport number of its legal representative.";
	//---
	$netim_au_rules="The domain name being registered must relate to applicant, or his activities, who can demonstrate a substantial link with Australia.";
	$netim_au_org_rules="This extension is restricted to Australian assocations / clubs / non profit organizations.";
	$netim_au_id_rules="This extension is restricted to individuals residing in Australia.";
	$netim_au_infos="Provide the identification number (ACN / ABN / trademark number) according to registrant's eligibility.";
	$netim_au_org_infos="Provide the identification number according to registrant's eligibility";
	$netim_au_id_type = "Registrant ID Number type";
	$netim_au_id_type_dropdown_acn = "Australian Company Number - ACN";
	$netim_au_id_type_dropdown_abn = "Australian Business Number - ABN";
	$netim_au_id_type_dropdown_tm = "Trademark Number";
	$netim_au_id = "Registrant ID number";
	$netim_au_id_desc = "ACN / ABN / trademark number";
	$netim_au_org_id_desc = "Legal entity registration number";
	$netim_au_el_type = "Eligibility Type";
	$netim_au_el_type_dropdown_ass = "Australian incorporated association";	
	$netim_au_el_type_dropdown_club = "Australian club";
	$netim_au_el_type_dropdown_nprofit = "Australian non-Profit organisation";
	$netim_au_el_type_dropdown_co = "Australian company";
	$netim_au_el_type_dropdown_rb = "Australian registered Business";
	$netim_au_el_type_dropdown_st = "Australian sole Trader";
	$netim_au_el_type_dropdown_tm = "Owner of a trademark valid in Australia";
	//---
	$netim_ax_registrant_type="Registrant's type";
	$netim_ax_registrant_org="Legal entity (whatever country)";
	$netim_ax_registrant_ind="Individual (whatever country)";
	$netim_ax_infos=".AX domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_ax_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_ax_registrant_ind</strong>: provide the ID number such as ID card or passport number</li>
        </ul>";
	$netim_ax_companynumber = "Legal entity registration number";
	$netim_ax_companynumber_desc = $netim_mandatory_org;
	$netim_ax_idnumber = "ID number";
	$netim_ax_idnumber_desc = "$netim_mandatory_ind: ID number such as ID card or passport number";
	//---
	$netim_ba_rules=".BA domains are restricted to registrants with an address in Bosnia Herzegovina. The administrative contact must also have a local address.";
	//---
	$netim_barcelona_use = "Intended use of the domain";
	//---
	$netim_bg_rules = ".BG domains are restricted to legal entities registered in European Union.";
	$netim_bg_infos = "In order to proceed with the domain registration, an application form must be signed by the legal representative and sent back together with a certificate of incorporation.";
	$netim_bg_companyname = "Legal entity name";
	$netim_bg_vatnumber = "E.U. VAT number";
	$netim_bg_firstname = "Representative's firstname";
	$netim_bg_lastname = "Representative's lastname";
	//---
	$netim_br_registrant_type="Registrant's type";
	$netim_br_registrant_org="Legal entity registered in Brazil";
	$netim_br_registrant_ind="Brazilian citizen residing in Brazil";
	$netim_br_infos="Brazilian domains have different required values depending on the registrant's eligibility type:
		<ul>
            <li><strong>$netim_br_registrant_org</strong>: provide the CPNJ number</li>
            <li><strong>$netim_br_registrant_ind</strong>: provide the CPF number</li>
        </ul>";
	$netim_br_companynumber = "Legal entity registration number (CPNJ)";
	$netim_br_companynumber_desc = $netim_mandatory_org;
	$netim_br_idnumber = "ID number (CPF)";
	$netim_br_idnumber_desc = $netim_mandatory_ind;
	//--
	$netim_by_registrant_type="Registrant's type";
	$netim_by_registrant_org="Legal entity (outside Belarus)";
	$netim_by_registrant_ind="Individual (outside Belarus)";
	$netim_by_infos=".BY / .бел domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_by_registrant_ind</strong>: provide the ID number and passport information</li>
            <li><strong>$netim_by_registrant_org</strong>: No required value</li>
         </ul>";
	$netim_by_idnumber = "ID number";
	$netim_by_idnumber_desc  = "$netim_mandatory_ind. ID card number";
	$netim_by_passportnumber = "Passport number";
	$netim_by_passportnumber_desc = $netim_mandatory_ind;
	$netim_by_passportissuer = "Passport issued by";
	$netim_by_passportissuer_desc = "Country of issuance. $netim_mandatory_ind.";
	$netim_by_passportdate = "Passport issue date";
	$netim_by_passportdate_desc = "$netim_date_format. $netim_mandatory_ind.";
	//--
	$netim_ca_rules=".CA domains are restricted to people and legal entities residing in Canada or trademarks valid in Canada. Except for legal type CCT and TDM, the registrant must have an address in Canada. The administrative contact must also have a local address. Learn more about <a href='https://www.cira.ca/sites/default/files/policy/canadian-presence-requirements-for-registrants.pdf' target='blank'>Canadian Presence Requirements</a>.";
	$netim_ca_infos="Select the legal type of the registrant";
	$netim_ca_registrant_type = "Legal Type";
	$netim_ca_registrant_CCO = "Canadian Corporation";
	$netim_ca_registrant_CCT = "Canadian Citizen";
	$netim_ca_registrant_RES = "Permanent Resident of Canada";
	$netim_ca_registrant_GOV = "Canadian Government";
	$netim_ca_registrant_EDU = "Canadian Educational Institution";
	$netim_ca_registrant_ASS = "Canadian Unincorporated Association";
	$netim_ca_registrant_HOP = "Canadian Hospital";
	$netim_ca_registrant_PRT = "Partnership Registered in Canada";
	$netim_ca_registrant_TDM = "Trade-mark registered in Canada";
	$netim_ca_registrant_TRD = "Canadian Trade Union";
	$netim_ca_registrant_PLT = "Canadian Political Party";
	$netim_ca_registrant_LAM = "Canadian Library Archive or Museum";
	$netim_ca_registrant_LGR = "Legal Representative of a Canadian Citizen";
	$netim_ca_registrant_ABO = "Aboriginal Peoples indigenous to Canada";
	$netim_ca_registrant_OMK = "Official mark registered in Canada";
	$netim_ca_registrant_TRS = "Trust established in Canada";
	//---
	$netim_cat_rules = ".CAT domains are reserved for catalan community. A website in catalan or promoting catalan culture (even partially) should be published within 6 months.";
	$netim_cat_use = "Intended use of the domain";
	//---
	$netim_cl_registrant_type="Registrant's type";
	$netim_cl_registrant_org="Legal entity (whatever country)";
	$netim_cl_registrant_ind="Individual (whatever country)";
	$netim_cl_infos=".CL domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_cl_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
            <li><strong>$netim_cl_registrant_org</strong>: provide the registration number</li> 
        </ul>";
	$netim_cl_companynumber = "Legal entity registration number";
	$netim_cl_companynumber_desc = $netim_mandatory_org;
	$netim_cl_idnumber = "ID number";
	$netim_cl_idnumber_desc = "$netim_mandatory_ind: ID number such as ID card or passport number";
	//--
	$netim_coop_rules = ".COOP domains are reserved to democratically controlled member-owned cooperatives (consistent with the International 7 Cooperative Principles), associations comprised of cooperatives, organizations that is majority controlled by a Cooperative, entities whose operations are principally dedicated to serving Cooperatives.";
	//---
	$netim_cr_registrant_type="Registrant's type";
	$netim_cr_registrant_org="Legal entity (whatever country)";
	$netim_cr_registrant_ind="Individual (whatever country)";
	$netim_cr_infos=".CR domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_cr_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_cr_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_cr_companynumber = "Legal entity registration number";
	$netim_cr_companynumber_desc = "Mandatory for legal entities";
	$netim_cr_idnumber = "ID number";
	$netim_cr_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//--	
	$netim_cy_registrant_type="Registrant's type";
	$netim_cy_registrant_org="Legal entity (whatever country)";
	$netim_cy_registrant_ind="Individual (whatever country)";
	$netim_cy_infos=".CY domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_cy_registrant_ind</strong>: provide an ID number such as ID card or passport number and date of birth</li>
            <li><strong>$netim_cy_registrant_org</strong>: provide the registration number</li>  
        </ul>";
	$netim_cy_notices="Limited to 1 domain per individual / 10 domains per organization.";	
	$netim_cy_companynumber = "Legal entity registration number";
	$netim_cy_companynumber_desc = $netim_mandatory_org;
	$netim_cy_idnumber = "ID number";
	$netim_cy_idnumber_desc = $netim_mandatory_ind;
	$netim_cy_birthdate = "Date of birth";
	$netim_cy_birthdate_desc = "$netim_mandatory_ind. $netim_date_format";
	//---
	$netim_dj_use = "Intended use of the domain";
	//--
	$netim_dk_infos = "By allowing us to be payer on your domain name, you agree that you give us the right to make payments to DK Hostmaster on your behalf.[BR] You can at any point change this at DK Hostmaster's self-service. Read more about DK Hostmaster and paying directly to DK Hostmaster here <a href='https://www.dk-hostmaster.dk/dk-hostmaster' target='_blank'>https://www.dk-hostmaster.dk/dk-hostmaster</a>";
	//---
	$netim_do_registrant_type="Registrant's type";
	$netim_do_registrant_org="Legal entity (whatever country)";
	$netim_do_registrant_ind="Individual (whatever country)";
	$netim_do_infos=".DO domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_do_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_do_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_do_companynumber = "Legal entity registration number";
	$netim_do_companynumber_desc = "Mandatory for legal entities";
	$netim_do_idnumber = "ID number";
	$netim_do_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//---
	$netim_dz_rules=".DZ domains are restricted to legal entities in Algeria.<br>The domain name must match the name of the legal entity.";
	$netim_dz_notices = "In order to proceed with the domain registration, an application form must be signed by the registrant and sent back together with required documentation.";
  	$netim_dz_companynumber = "Legal entity registration number";
	//---
	$netim_ec_registrant_type="Registrant's type";
	$netim_ec_registrant_org="Legal entity (whatever country)";
	$netim_ec_registrant_ind="Individual (whatever country)";
	$netim_ec_infos=".EC domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_ec_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_ec_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_ec_companynumber = "Legal entity registration number";
	$netim_ec_companynumber_desc = "Mandatory for legal entities";
	$netim_ec_idnumber = "ID number";
	$netim_ec_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//-
	$netim_ee_registrant_type="Registrant's type";
	$netim_ee_registrant_org="Legal entity (whatever country)";
	$netim_ee_registrant_ind="Individual (whatever country)";
	$netim_ee_infos=".EE domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_ee_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_ee_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_ee_companynumber = "Legal entity registration number";
	$netim_ee_companynumber_desc = "Mandatory for legal entities";
	$netim_ee_idnumber = "ID number";
	$netim_ee_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//---
	$netim_eg_rules=".EG domains are restricted to legal entities with a registered trademark covering the Egyptian territory. The domain name must have a link with the registant (company name, trademark, line of business...)";
	$netim_eg_rules_2LVL="This extension is restricted to legal entities registered in Egypt with a registered trademark covering the Egyptian territory. The  domain name must have a link with the registant (company name, trademark, line of business...)";
	//--
	$netim_es_registrant_type="Registrant's type";
	$netim_es_registrant_foreign="Non Spanish individual or legal entity";
	$netim_es_registrant_es="Spanish Citizen or legal entity";
	$netim_es_registrant_ind_es="Foreigner living in Spain";
	$netim_es_infos=".ES domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_es_registrant_foreign</strong>: provide a Foreign number such as registration number for legal entities or ID card/Passport number for individuals</li>
            <li><strong>$netim_es_registrant_es</strong>: provide the NIF number</li>
            <li><strong>$netim_es_registrant_ind_es</strong>: provide the NIE number</li>
         </ul>";
	$netim_es_for = "Foreign number";
	$netim_es_for_desc = "Mandatory for $netim_es_registrant_foreign. Registration number for legal entities or ID card/Passport number for individuals";
	$netim_es_nif = "NIF number";
	$netim_es_nif_desc = "Mandatory for $netim_es_registrant_es";
	$netim_es_nie = "NIE number";
	$netim_es_nie_desc = "Mandatory for $netim_es_registrant_ind_es";
	//---
	$netim_eu_rules = "This extension is restricted to registrants with an address in European Union, Iceland, Norway, Liechtenstein or having European Union citizenship.";
	$netim_eu_registrant_type="Registrant's type";
	$netim_eu_registrant_resident="Resident in an European State, Iceland, Norway, Liechtenstein";
	$netim_eu_registrant_citizen="European Union citizen";
	$netim_eu_infos=".eu / .ею / .ευ domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_eu_registrant_resident</strong>: no required values</li>
            <li><strong>$netim_eu_registrant_citizen</strong>: provide the country of citizenship</li>
         </ul>";
	$netim_eu_citizenship = "Country of citizenship";
	$netim_eu_citizenship_desc = "Mandatory for $netim_eu_registrant_citizen";
	$netim_eu_country_AT="Austria";
	$netim_eu_country_BE="Belgium";
	$netim_eu_country_BG="Bulgaria";
	$netim_eu_country_CY="Cyprus";
	$netim_eu_country_CZ="Czech Republic";
	$netim_eu_country_DE="Germany";
	$netim_eu_country_DK="Denmark";
	$netim_eu_country_EE="Estonia";
	$netim_eu_country_ES="Spain";
	$netim_eu_country_FI="Finland";
	$netim_eu_country_FR="France";
	$netim_eu_country_GR="Greece";
	$netim_eu_country_HR="Croatia";
	$netim_eu_country_HU="Hungary";
	$netim_eu_country_IE="Ireland";
	$netim_eu_country_IT="Italy";
	$netim_eu_country_LT="Lithuania";
	$netim_eu_country_LU="Luxembourg";
	$netim_eu_country_LV="Latvia";
	$netim_eu_country_MT="Malta";
	$netim_eu_country_NL="Netherlands";
	$netim_eu_country_PL="Poland";
	$netim_eu_country_PT="Portugal";
	$netim_eu_country_RO="Romania";
	$netim_eu_country_SE="Sweden";
	$netim_eu_country_SI="Slovenia";
	$netim_eu_country_SK="Slovakia";	
	//--
	$netim_eus_use = "Intended use of the domain";
	//--
	$netim_fi_registrant_type="Registrant's type";
	$netim_fi_registrant_org="Legal entity (whatever country)";
	$netim_fi_registrant_ind_fi="Individual residing in Finland";
	$netim_fi_registrant_ind="Individual (Other countries)";
	$netim_fi_infos=".FI domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_fi_registrant_org</strong>: provide the registration number. (Y-tunnus for Finnish entities)</li>
            <li><strong>$netim_fi_registrant_ind_fi</strong>: provide the Finnish PIN number (HETU)</li>
            <li><strong>$netim_fi_registrant_ind</strong>: provide the date of birth</li>
         </ul>";
	$netim_fi_companynumber = "Legal entity registration number";
	$netim_fi_companynumber_desc = "Mandatory for $netim_fi_registrant_org. (Y-tunnus for Finnish entities)";
	$netim_fi_idnumber = "Finnish PIN number";
	$netim_fi_idnumber_desc = "Mandatory for $netim_fi_registrant_ind_fi. (HETU)";
	$netim_fi_birthdate = "Date of birth";
	$netim_fi_birthdate_desc = "Mandatory for $netim_fi_registrant_ind. $netim_date_format";
	//---
	$netim_fr_rules="This extension is restricted to registrants with an address in European Union, Iceland, Norway, Liechtenstein or Switzerland.";
	//---
	$netim_gal_use = "Intended use of the domain";
	//--
	$netim_gn_rules="Third level domain under .GN extension are restricted to legal entities registered in Guinea.";
	$netim_gn_notices="Limited to 1 domain per organization.";	
	$netim_gn_use = "Intended use of the domain";
	//--
	$netim_gw_registrant_type="Eligibility type";
	$netim_gw_registrant_org="The domain name matches the legal entity name";
	$netim_gw_registrant_tm="The domain name matches the trademark name";
	$netim_gw_rules=".GW domains are restricted to legal entities (whatever country) with a right on the domain.";
	$netim_gw_infos="Different required values are needed depending on the eligibility:<ul>
            <li><strong>$netim_gw_registrant_org</strong>: provide the name and registration number</li>
            <li><strong>$netim_gw_registrant_tm</strong>: provide the name and the number of the trademark</li>
        </ul>";
	$netim_gw_companyname = "Legal entity name";
	$netim_gw_companynumber = "Legal entity registration number";
	$netim_gw_org_desc = "Mandatory if $netim_gw_registrant_org";
	$netim_gw_tmname = "Trademark name";
	$netim_gw_tmnumber = "Trademark number";
	$netim_gw_tm_desc = "Mandatory if $netim_gw_registrant_tm";
	//---
	$netim_hr_rules="This extension is restricted to Croatian citizens, legal entities registered in Croatia or in European Union with a VAT number.";
	$netim_hr_registrant_type="Registrant's type";
	$netim_hr_registrant_org="Legal entity registered in European Union";
	$netim_hr_registrant_local="Legal entity registered in Croatia or Croatian citizen";
	$netim_hr_infos=".HR domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_hr_registrant_local</strong>: provide the OIB number</li>
			<li><strong>$netim_hr_registrant_org</strong>: provide the VAT number</li>
		</ul>";
	$netim_hr_2LV_infos="If the registrant is a $netim_hr_registrant_local, provide the OIB number. <strong>No required values for foreigners.</strong>";
	$netim_hr_vatnumber = "E.U. VAT number";
	$netim_hr_vatnumber_desc = "Mandatory for $netim_hr_registrant_org";
	$netim_hr_oibnumber = "OIB number";
	$netim_hr_oibnumber_desc = "Mandatory for $netim_hr_registrant_local";
	//---
	$netim_hu_rules="This extension is restricted to registrants with an address in European Union, Iceland, Norway, Liechtenstein or Switzerland.";
	$netim_hu_registrant_type="Registrant's type";
	$netim_hu_registrant_org="Legal entity registered in European Union";
	$netim_hu_registrant_ind="Individual residing in European Union";
	$netim_hu_infos=".HU domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_hu_registrant_org</strong>: provide the E.U. VAT number</li>
			<li><strong>$netim_hu_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
		</ul>";
	$netim_hu_vatnumber = "E.U. VAT number";
	$netim_hu_vatnumber_desc = "Mandatory for $netim_hu_registrant_org";
	$netim_hu_idnumber = "ID number";
	$netim_hu_idnumber_desc = "Mandatory for $netim_hu_registrant_ind";
	//-
	$netim_coid_rules="This extension is restricted to legal entities registered in Indonesia.";
	//-
	$netim_ie_rules="The registrant, whether situated in Ireland or not, must demonstrate a real and substantive connection with Ireland.<br>
	The .ie registry will proceed with an ID verification of the registrant. Documents are required for irish individuals and all foreigners.<br>
	If the registrant is a foreigner, the .ie registry will check the evidence of the connection with Ireland (Trademark valid in Ireland, documents showing a trade with Ireland).";
	$netim_ie_registrant_org_ie="Irish legal entity";
	$netim_ie_registrant_org="Foreign legal entity";
	$netim_ie_registrant_ind_ie="Irish citizen/resident";
	$netim_ie_infos=".IE domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_ie_registrant_org_ie</strong>: provide the VAT number or the registration number (CRO / RBN / ROLL / ...)</li>
			<li><strong>$netim_ie_registrant_ind_ie</strong>: No required values</li>
			<li><strong>$netim_ie_registrant_org</strong>: provide the VAT number or the registration number and trademark information if applicable</li>
	</ul>";
	$netim_ie_vatnumber = "E.U. VAT number";
	$netim_ie_vatnumber_desc = "For Legal entities in European Union with such number";
	$netim_ie_companynumber = "Legal entity registration number";
	$netim_ie_companynumber_desc = "For Irish legal entities (CRO / RBN / ROLL / ...) or local registration number for foreigners";
	$netim_ie_tmname = "Trademark name";
	$netim_ie_tmnumber = "Trademark number";
	$netim_ie_tm_desc = "For foreigners to proove a connection with Ireland based on a trademark valid in the country";
	//---
	$netim_il_infos = "If the registrant is a legal entity (whatever country), provide the registration number. <strong>No required values for individuals.</strong>";
	$netim_il_companynumber = "Legal entity registration number";
	$netim_il_companynumber_desc = "Mandatory for legal entity";
	//-
	$netim_ir_registrant_type="Registrant's type";
	$netim_ir_registrant_org="Legal entity (whatever country)";
	$netim_ir_registrant_ind="Individual (whatever country)";
	$netim_ir_infos=".IR domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_ir_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_ir_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_ir_companynumber = "Legal entity registration number";
	$netim_ir_companynumber_desc = "Mandatory for legal entities";
	$netim_ir_idnumber = "ID number";
	$netim_ir_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//---
	$netim_is_infos = "If the registrant is a legal entity registered in Iceland or an icelandic citizen, provide the registration number or the Social Security Number accordingly. <strong>No required values for foreigners.</strong>";
	$netim_is_idnumber = "Social Security number";
	$netim_is_idnumber_desc = "Mandatory for icelandic citizen";
	$netim_is_companynumber = "Legal entity registration number";
	$netim_is_companynumber_desc = "Mandatory for legal entity registered in Iceland";
	//---
	$netim_it_rules="This extension is restricted to registrants with an address in European Union.";
	$netim_it_registrant_type="Registrant's type";
	$netim_it_registrant_org="Legal entity registered in European Union";
	$netim_it_registrant_ind="Individual residing in European Union";
	$netim_it_infos="Different values are required depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_it_registrant_org</strong>: provide the E.U. VAT number</li>
			<li><strong>$netim_it_registrant_ind</strong>: provide Fiscal code for italian, ID card / passport number for non italian</li>
		</ul>";
	$netim_it_vatnumber = "E.U. VAT number";
	$netim_it_vatnumber_desc = "Mandatory for $netim_it_registrant_org";
	$netim_it_idnumber = "ID number";
	$netim_it_idnumber_desc = "Mandatory for $netim_it_registrant_ind. Fiscal code for italian, ID card / passport number for non italian";
	//---
	$netim_jp_rules="The administrative contact must have a local address.";
	$netim_cojp_rules="This extension is restricted to legal entities registered in Japan.";
	//---
	$netim_kr_registrant_org="Legal entity registered in South Korea";
	$netim_kr_registrant_ind="Individual residing in South Korea";
	$netim_kr_infos=".KR domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_hu_registrant_org</strong>: select an ID document (BUSINESS / TAX / ORG / BRAND) and provide the corresponding legal entity number</li>
			<li><strong>$netim_hu_registrant_ind</strong>: select an ID document (SOCIAL / DRIVELIC / PASSPORT) and provide the corresponding ID number</li>
		</ul>";
	$netim_kr_doc = "ID document";
	$netim_kr_doc_desc = "BUSINESS/TAX/ORG/BRAND for Korean legal entities or SOCIAL / DRIVELIC / PASSPORT for Korean individuals";
	$netim_kr_doc_BUSINESS = "Business Registration Certificate";
	$netim_kr_doc_TAX = "Tax Registration Certificate";
	$netim_kr_doc_ORG = "Organization Registration Certificate";
	$netim_kr_doc_BRAND = "Brand Name Registration Certificate";
	$netim_kr_doc_SOCIAL = "Social Security Card";
	$netim_kr_doc_DRIVELIC = "Driver License";
	$netim_kr_doc_PASSPORT = "Passport";
	$netim_kr_idnumber = "ID number";
	$netim_kr_idnumber_desc = "Mandatory if SOCIAL / DRIVELIC / PASSPORT";
	$netim_kr_companynumber = "Legal entity number";
	$netim_kr_companynumber_desc = "Mandatory if BUSINESS/TAX/ORG/BRAND";
	//--
	$netim_law_rules = "This extension is reserved to qualified lawyers, law firms, courts of law, law schools, legal regulators. Domain applications are verified by a third party organisation. In case additional documentation is required, the Registrant will have 5 days to provide it.";
	//---
	$netim_lk_registrant_type="Registrant's type";
	$netim_lk_registrant_org="Legal entity (whatever country)";
	$netim_lk_registrant_ind="Individual (whatever country)";
	$netim_lk_infos=".LK domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_lk_registrant_org</strong>: provide the registration number and the ID number of its legal representative</li>
            <li><strong>$netim_lk_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_lk_companynumber = "Legal entity registration number";
	$netim_lk_companynumber_desc = "Mandatory for legal entities";
	$netim_lk_idnumber = "ID number";
	$netim_lk_idnumber_desc = "Mandatory in all cases";
	//--
	$netim_lr_rules="Third level domain under .LR extension are restricted to legal entities registered in Liberia.";
	$netim_lr_notices="Limited to 1 domain per organization.";	
	$netim_lr_use = "Intended use of the domain";
	//--
	$netim_lt_infos = "If the registrant is a legal entity (whatever country), provide the registration number";
	$netim_lt_companynumber = "Legal entity registration number";
	$netim_lt_companynumber_desc = "Mandatory for legal entities (whatever country)";
	//--
	$netim_lv_infos = "If the registrant is a legal entity registered in Latvia or a Latvian citizen, provide the registration number or the Personal ID Number accordingly. <strong>No required values for foreigners.</strong>";
	$netim_lv_idnumber = "ID number";
	$netim_lv_idnumber_desc = "Mandatory for Latvian citizens";
	$netim_lv_companynumber = "Legal entity registration number";
	$netim_lv_companynumber_desc = "Mandatory for legal entity registered in Latvia";
	//---
	$netim_ma_rules="The administrative contact must have a local address.";
	//---
	$netim_madrid_use = "Intended use of the domain";
	//--
	$netim_mc_rules=".MC domains are restricted to legal entities registered in Monaco or owners of trademarks covering the Monegasque territory.<br>The domain name must match the name of the legal entity or the trademark name.";
	$netim_mc_caution="In order to proceed with the domain registration, an application form must be signed by the legal representative.";
	//-
	$netim_mk_registrant_type="Registrant's type";
	$netim_mk_registrant_org="Legal entity (whatever country)";
	$netim_mk_registrant_ind="Individual (whatever country)";
	$netim_mk_infos=".MK domains have different required values depending on the registrant's legal form:
		<ul>
		 	<li><strong>$netim_mk_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
            <li><strong>$netim_mk_registrant_org</strong>: provide the TAX number or the registration number</li>
        </ul>";
	$netim_mk_companynumber = "Legal entity TAX or registration number";
	$netim_mk_companynumber_desc = "Mandatory for legal entities";
	$netim_mk_idnumber = "ID number";
	$netim_mk_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//--
	$netim_mr_rules=".MR domains are restricted to Mauritanian citizen, resident and legal entities registered in Mauritania, owners of trademarks covering the Mauritanian territory.";
	$netim_mr_registrant_type="Eligibility type";
	$netim_mr_registrant_ind="The owner is an individual residing in Mauritania";
	$netim_mr_registrant_org="The owner is a registered company registered in Mauritania";
	$netim_mr_registrant_cit="The owner is a Mauritanian citizen";
	$netim_mr_registrant_tm="Domain name matches with the name of a trademark";
	$netim_mr_infos="Different values are required depending on the registrant's eligibility type:
		<ul>
            <li><strong>$netim_mr_registrant_tm</strong>: provide the registration number and the name of the trademark. <i>The domain name must match the trademark name.</i></li>
        </ul>";
	$netim_mr_tmname = "Trademark name";
	$netim_mr_tmnumber = "Trademark number";
	$netim_mr_tm_desc = "Mandatory if $netim_mr_registrant_tm";
	//--
	$netim_mt_rules=".MT domains are restricted to registrants having the right to use the domain name as a full Trade Mark, Trade or Business Name in accordance with Maltese Law.";
	$netim_mt_registrant_type="Registrant's type";
	$netim_mt_registrant_org="Domain name matches with the name of the legal entity";
	$netim_mt_registrant_tm="Domain name matches with the name of a trademark";
	$netim_mt_infos="Different values are required depending on the registrant's eligibility type:
		<ul>
		 	<li><strong>$netim_mt_registrant_org</strong>: provide the registration number and the entity name. <i>The domain name must match the legal entity name.</i></li>
            <li><strong>$netim_mt_registrant_tm</strong>: provide the registration number and the name of the trademark. <i>The domain name must match the trademark name.</i></li>
        </ul>";
	$netim_mt_companyname = "Legal entity name";
	$netim_mt_companynumber = "Legal entity registration number";
	$netim_mt_org_desc = "Mandatory if $netim_mt_registrant_org";
	$netim_mt_tmname = "Trademark name";
	$netim_mt_tmnumber = "Trademark number";
	$netim_mt_tm_desc = "Mandatory if $netim_mt_registrant_tm";
	//--
	$netim_my_rules=".MY domains are restricted to legal entities registered in Malaysia, Malaysian citizens or permanent resident in Malaysia.";
	$netim_my_rules_2LVL="This extension is restricted to legal entities registered in Malaysia.";
	$netim_my_registrant_type="Registrant's type";
	$netim_my_registrant_org="Legal entity registered in Malaysia";
	$netim_my_registrant_ind="Malaysian citizen or permanent residant in Malaysia";
	$netim_my_infos="Different values are required depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_my_registrant_org</strong>: provide the registration number (ROC / ROB / ROS)</li>
			<li><strong>$netim_my_registrant_ind</strong>: provide the ID number (MyKad or passport)</li>
		</ul>";
	$netim_my_infos_2LV="Please provide the registration number (ROC / ROB / ROS number)";
	$netim_my_companynumber = "Legal entity registration number";
	$netim_my_companynumber_desc = "Mandatory for $netim_my_registrant_org. ROC / ROB / ROS number";
	$netim_my_idnumber = "ID number";
	$netim_my_idnumber_desc = "Mandatory for $netim_my_registrant_ind. MyKad or passport number";
	//--
	$netim_no_rules=".NO domains are restricted to legal entities registered in Norway or Norwegian citizens having an address in Norway.";
	$netim_no_registrant_type="Registrant's type";
	$netim_no_registrant_org="Legal entity registered in Norway";
	$netim_no_registrant_ind="Norwegian citizen being 18+ residing in Norway";
	$netim_no_pid="If you don't have a PID yet, <a href='https://pid.norid.no/personid/lookup' target='blank'>you can request a PID here</a>";
	$netim_no_infos=".NO domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_no_registrant_org</strong>: provide the company number</li>
			<li><strong>$netim_no_registrant_ind</strong>: provide the registrant's .NO PID number. $netim_no_pid</li>
		</ul>";
	$netim_no_notices="Limited to 5 domain per individual / 100 domains per entity.";
	$netim_no_companynumber = "Legal entity registration number";
	$netim_no_companynumber_desc = "Mandatory for $netim_no_registrant_org";
	$netim_no_idnumber = ".NO PID number";
	$netim_no_idnumber_desc = "Mandatory for $netim_no_registrant_ind. $netim_no_pid";
	//--
	$netim_nu_registrant_type="Registrant's type";
	$netim_nu_registrant_org_eu="Legal entity registered in European Union";
	$netim_nu_registrant_org="Legal entity (Other countries)";
	$netim_nu_registrant_ind="Individual (whatever country)";
	$netim_nu_infos=".NU domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_nu_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
			<li><strong>$netim_nu_registrant_org_eu</strong>: provide the E.U. VAT number and the registration number</li>
			<li><strong>$netim_nu_registrant_org</strong>: provide the registration number</li>
		</ul>";
	$netim_nu_companynumber = "Legal entity registration number";
	$netim_nu_companynumber_desc = "Mandatory for Legal entities";
	$netim_nu_vatnumber = "E.U. VAT number";
	$netim_nu_vatnumber_desc = "Mandatory for $netim_nu_registrant_org_eu";
	$netim_nu_idnumber = "ID number";
	$netim_nu_idnumber_desc = "Mandatory for $netim_nu_registrant_ind";
	//--
	$netim_ong_ngo_rules="This extension is restricted to Non-Governmental Organisations or Members of the .ONG community. Organisations formed under the laws of the People's Republic of China are not eligible.";
	$netim_ong_ngo_notices="The registry conducts random audits by requesting documentation of NGO status and reserves the right to delete any non-compliant domain.";
	//-
	$netim_pe_registrant_type="Registrant's type";
	$netim_pe_registrant_org="Legal entity (whatever country)";
	$netim_pe_registrant_ind="Individual (whatever country)";
	$netim_pe_infos=".PE domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_pe_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
		    <li><strong>$netim_pe_registrant_org</strong>: provide the registration number</li>
        </ul>";
	$netim_pe_companynumber = "Legal entity registration number";
	$netim_pe_companynumber_desc = "Mandatory for legal entities";
	$netim_pe_idnumber = "ID number";
	$netim_pe_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//--
	$netim_pt_registrant_type="Registrant's type";
	$netim_pt_registrant_org="Legal entity (whatever country)";
	$netim_pt_registrant_ind="Individual (whatever country)";
	$netim_pt_infos=".PT domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_pt_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
			<li><strong>$netim_pt_registrant_org</strong>: provide the registration number or the E.U VAT number if any</li>
		</ul>";
	$netim_pt_companynumber = "Legal entity registration number";
	$netim_pt_companynumber_desc = "Registration number or E.U. VAT number mandatory for Legal entities";
	$netim_pt_vatnumber = "E.U. VAT number";
	$netim_pt_idnumber = "ID number";
	$netim_pt_idnumber_desc = "Mandatory for $netim_pt_registrant_ind";
	//---
	$netim_radio_rules="An individual or a legal entity with a nexus with the Radio community (broadcasting livestreams, radio programs related content, individual radio professional activities, radio-related events, radio-related services or equipment provision and diffusion, and any other in which the registrant provides content for the benefit and advancement of the .radio community)";
	$netim_radio_use = "Intended use of the domain";
	//--
	$netim_ro_infos = "If the registrant is a legal entity registered in Romania or a Romanian citizen, provide the registration number and the VAT number or the CNP number accordingly. <strong>No required values for foreigners.</strong>";
	$netim_ro_companynumber = "Legal entity registration number";
	$netim_ro_companynumber_desc = "Mandatory for Romanian legal entities";
	$netim_ro_vatnumber = "E.U. VAT number";
	$netim_ro_vatnumber_desc = "Mandatory for Romanian legal entities";
	$netim_ro_idnumber = "CNP number";
	$netim_ro_idnumber_desc = "Mandatory for Romanian citizens or non incorporated entities";
	//--
	$netim_rs_infos = "If the registrant is a legal entity (whatever country), provide the registration number";
	$netim_rs_rules_2LVL = "This extension is restricted to legal entities.";
	$netim_rs_companynumber = "Legal entity registration number";
	$netim_rs_companynumber_desc = "Mandatory for legal entities (whatever country)";
	//--
	$netim_ru_registrant_type="Registrant's type";
	$netim_ru_registrant_org_ru="Legal entity registered in Russia";
	$netim_ru_registrant_org_other="Legal entity (Other countries)";
	$netim_ru_registrant_ind="Individual (whatever country)";
	$netim_ru_infos="This extension has different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_ru_registrant_ind</strong>: provide an ID number such as ID card or passport number and date of birth</li>
            <li><strong>$netim_ru_registrant_org_ru</strong>: provide TIN and KPP numbers</li>
            <li><strong>$netim_ru_registrant_org_other</strong>: No required value</li>
         </ul>";
	$netim_ru_tin = "TIN";
	$netim_ru_tin_desc = "$netim_mandatory_org in Russia";
	$netim_ru_kpp = "KPP";
	$netim_ru_kpp_desc = "$netim_mandatory_org in Russia";
	$netim_ru_idnumber = "ID number";
	$netim_ru_idnumber_desc  = "$netim_mandatory_ind. ID number such as ID card or passport number";
	$netim_ru_birthdate = "Date of birth";
	$netim_ru_birthdate_desc = "$netim_mandatory_ind. $netim_date_format";
	//---
	$netim_sa_rules=".SA domains are restricted to legal entities registered in Saudi Arabia or owners of registered trademarks covering the Saudi Arabia territory.";
	$netim_sa_registrant_type="Eligibility type";
	$netim_sa_registrant_org="Legal entities registered in Saudi Arabia";
	$netim_sa_registrant_tm="Registered trademark covering the Saudi Arabia territory";
	$netim_sa_infos="Different documents will be requested depending on the eligibility type:
		<ul>
		 	<li><strong>$netim_sa_registrant_org</strong>: the certificate of incorporation</li>
            <li><strong>$netim_sa_registrant_tm</strong>: the trademark certificate which the name matches the domain name</li>
        </ul>";
	//--
	$netim_se_registrant_type="Registrant's type";
	$netim_se_registrant_org_eu="Legal entity registered in European Union";
	$netim_se_registrant_org="Legal entity (Other countries)";
	$netim_se_registrant_ind="Individual (whatever country)";
	$netim_se_infos=".SE domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_se_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
			<li><strong>$netim_se_registrant_org_eu</strong>: provide the E.U. VAT number and the registration number</li>
			<li><strong>$netim_se_registrant_org</strong>: provide the registration number</li>
		</ul>";
	$netim_se_companynumber = "Legal entity registration number";
	$netim_se_companynumber_desc = "Mandatory for Legal entities";
	$netim_se_vatnumber = "E.U. VAT number";
	$netim_se_vatnumber_desc = "Mandatory for $netim_se_registrant_org_eu";
	$netim_se_idnumber = "ID number";
	$netim_se_idnumber_desc = "Mandatory for $netim_se_registrant_ind";
	//---
	$netim_sg_rules_2LVL=".COM.SG domains are restricted to legal entities (whatever country).";
	$netim_sg_registrant_type="Registrant's type";
	$netim_sg_registrant_org="Legal entity (whatever country)";
	$netim_sg_registrant_ind="Individual (whatever country)";
	$netim_sg_infos=".SG domains have different required values depending on the registrant's legal form:
		<ul>
            <li><strong>$netim_sg_registrant_org</strong>: provide the registration number</li>
            <li><strong>$netim_sg_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
        </ul>";
	$netim_sg_companynumber = "Legal entity registration number";
	$netim_sg_companynumber_desc = "Mandatory for legal entities";
	$netim_sg_idnumber = "ID number";
	$netim_sg_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//--
	$netim_sk_rules="This extension is restricted to registrants with an address in European Union, Iceland, Norway, Liechtenstein or Switzerland.";
	$netim_sk_companynumber = "Registration number for legal entity";
	$netim_sk_companynumber_desc = "Mandatory for legal entities";
	//---
	$netim_sport_use = "Intended use of the domain";
	//---
	$netim_swiss_rules=".SWISS domains are restricted to legal entities registered in Switzerland and several requirements must be fulfilled. <a href='https://www.nic.swiss/dam/nic/en/dokumente/swiss-Policy-Registration-Policy-edition2-e.pdf.download.pdf/swiss-Policy-Registration-Policy-edition3-e.pdf' target='blank'>More information about eligibility criteria</a>.";
	$netim_swiss_infos="Provide the registration number (UID/IDE/IDI) and the intended use of the domain.";
	$netim_swiss_use = "Intended use";
	$netim_swiss_companynumber = "UID/IDE/IDI number";
	$netim_swiss_companynumber_desc = "Swiss legal entity registration number";
	//---
	$netim_tn_rules=".TN domains are restricted to legal entities registered in Tunisia or Tunisian citizens.";
	$netim_comtn_rules=".COM.TN domains are restricted to legal entities registered in Tunisia.";
	//--
	$netim_travel_agreement = "The registrant must declare to provide or plan to provide services, products or content in or to the travel industry.";
	//--
	$netim_tr_registrant_type="Registrant's type";
	$netim_tr_registrant_org="Legal entity (whatever country)";
	$netim_tr_registrant_ind="Individual (whatever country)";
	$netim_tr_infos=".TR domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_pe_registrant_ind</strong>: provide an ID number such as ID card or passport number</li>
		    <li><strong>$netim_pe_registrant_org</strong>: provide the registration number</li>
        </ul>";
	$netim_tr_companynumber = "Legal entity registration number";
	$netim_tr_companynumber_desc = "Mandatory for legal entities";
	$netim_tr_idnumber = "ID number";
	$netim_tr_idnumber_desc = "Mandatory for individuals: ID number such as ID card or passport number";
	//---
	$netim_tw_registrant_type="Registrant's type";
	$netim_tw_registrant_org="Legal entity (whatever country)";
	$netim_tw_registrant_ind="Individual (whatever country)";
	$netim_tw_infos=".TW domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_tw_registrant_org</strong>: provide the registration number and the ID number of its legal representative</li>
			<li><strong>$netim_tw_registrant_ind</strong>: provide an ID number such as ID card or passport number and date of birth</li>
		</ul>";
	$netim_tw_companynumber = "Legal entity registration number";
	$netim_tw_companynumber_desc = "Mandatory for legal entities";
	$netim_tw_idnumber = "ID number";
	$netim_tw_idnumber_desc = "Mandatory in all cases";
	$netim_tw_birthdate = "Date of birth";
	$netim_tw_birthdate_desc = "$netim_date_format. Mandatory for individuals.";
	$netim_tw_rules_2LVL="Third level domain under .TW extension are restricted to legal entities (Whatever countries).";
	$netim_tw_infos_2LVL="Provide the registration number and ID card or passport number of its legal representative.";
	//---
	$netim_ua_rules=".UA domains are restricted to trademarks valid in Ukraine. The domain name must match the trademark name.";
	$netim_ua_tmname = "Trademark name";
	$netim_ua_tmtype = "Trademark type";
	$netim_ua_tmtype_INPI = "National in Ukraine";
	$netim_ua_tmtype_WIPO = "International showing Ukraine as country";
	$netim_ua_tmnumber = "Trademark number";
	//---
	$netim_uk_infos = "If the registrant is a legal entity in the U.K., provide the type and the registration number if any. <strong>Otherwise no value required.</strong>";
	$netim_uk_type = "Legal entity type";
	$netim_uk_type_desc = "If the registrant is a legal entity in the U.K.";
	$netim_uk_type_LTD = "UK Limited Company";
	$netim_uk_type_PLC = "UK Public Limited Company";
	$netim_uk_type_PTNR = "UK Partnership";
	$netim_uk_type_STRA = "UK Sole Trader";
	$netim_uk_type_LLP = "UK Limited Liability Partnership";
	$netim_uk_type_IP = "Industrial/Provident Registered Company";
	$netim_uk_type_SCH = "UK School";
	$netim_uk_type_RCHAR = "UK Registered Charity";
	$netim_uk_type_GOV = "UK Government Body";
	$netim_uk_type_CRC = "UK Corporation by Royal Charter";
	$netim_uk_type_STAT = "UK Statutory Body";
	$netim_uk_type_OTHER = "UK Other Entity";
	$netim_uk_companynumber = "Legal entity registration number";
	//---
	$netim_us_rules = ".US domains are restricted to people and entities having a substantive link with the USA.";
	$netim_us_infos =" Provide the application purpose and the registrant's category";
	$netim_us_purpose = "Application Purpose";
	$netim_us_purpose_desc = "";
 	$netim_us_purpose_P1 = "Business use for profit";
	$netim_us_purpose_P2 = "Non-profit business";
	$netim_us_purpose_P3 = "Personal Use";
	$netim_us_purpose_P4 = "Educational purposes";
	$netim_us_purpose_P5 = "Government purposes";
	$netim_us_category = "Nexus category";
	$netim_us_category_desc = "";
	$netim_us_category_C11 = "Citizen of the USA";
	$netim_us_category_C12 = "Permanent resident of the USA";
	$netim_us_category_C21 = "Organization incorporated in the USA";
	$netim_us_category_C31 = "Foreigner having substantial link with the USA";
	$netim_us_category_C32 = "Entity with an office or other facility in the USA";
	//-
	$netim_vn_registrant_type="Registrant's type";
	$netim_vn_registrant_org="Legal entity (Outside Vietnam)";
	$netim_vn_registrant_ind="Individual (Outside Vietnam)";
	$netim_vn_infos=".VN domains have different required values depending on the registrant's legal form:
		<ul>
			<li><strong>$netim_vn_registrant_ind</strong>: provide an ID number such as ID card or passport number and the date of birth</li>
			<li><strong>$netim_vn_registrant_org</strong>: provide the registration number and the ID number of the legal representative (ID card or passport)</li>
		</ul>";
	$netim_vn_rules = "The registrant must reside outside Vietnam. Vietnamese residents must register the domains directly with a local Registrar.";
	$netim_vn_companynumber = "Legal entity registration number";
	$netim_vn_companynumber_desc = "Mandatory for $netim_vn_registrant_org";
	$netim_vn_idnumber = "ID number";
	$netim_vn_idnumber_desc = "Mandatory for $netim_vn_registrant_ind";
	$netim_vn_birthdate = "Date of birth";
	$netim_vn_birthdate_desc = "Mandatory for $netim_vn_registrant_ind. $netim_date_format";
?>