<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * ModelBreak Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class ModelBreak implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'start_at' => 'string',
        'end_at' => 'string',
        'break_type_id' => 'string',
        'name' => 'string',
        'expected_duration' => 'string',
        'is_paid' => 'bool'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'start_at' => 'start_at',
        'end_at' => 'end_at',
        'break_type_id' => 'break_type_id',
        'name' => 'name',
        'expected_duration' => 'expected_duration',
        'is_paid' => 'is_paid'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'start_at' => 'setStartAt',
        'end_at' => 'setEndAt',
        'break_type_id' => 'setBreakTypeId',
        'name' => 'setName',
        'expected_duration' => 'setExpectedDuration',
        'is_paid' => 'setIsPaid'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'start_at' => 'getStartAt',
        'end_at' => 'getEndAt',
        'break_type_id' => 'getBreakTypeId',
        'name' => 'getName',
        'expected_duration' => 'getExpectedDuration',
        'is_paid' => 'getIsPaid'
    );
  
    /**
      * $id UUID for this object
      * @var string
      */
    protected $id;
    /**
      * $start_at RFC 3339; follows same timezone info as `Shift`. Precision up to the minute is respected; seconds are truncated.
      * @var string
      */
    protected $start_at;
    /**
      * $end_at RFC 3339; follows same timezone info as `Shift`. Precision up to the minute is respected; seconds are truncated. The `end_at` minute is not counted when the break length is calculated. For example, a break from `00:00` to `00:11`  is considered a 10 minute break (midnight to 10 minutes after midnight).
      * @var string
      */
    protected $end_at;
    /**
      * $break_type_id The `BreakType` this `Break` was templated on.
      * @var string
      */
    protected $break_type_id;
    /**
      * $name A human-readable name.
      * @var string
      */
    protected $name;
    /**
      * $expected_duration Format: RFC-3339 P[n]Y[n]M[n]DT[n]H[n]M[n]S. The expected length of the break.
      * @var string
      */
    protected $expected_duration;
    /**
      * $is_paid Whether this break counts towards time worked for compensation purposes.
      * @var bool
      */
    protected $is_paid;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["start_at"])) {
              $this->start_at = $data["start_at"];
            } else {
              $this->start_at = null;
            }
            if (isset($data["end_at"])) {
              $this->end_at = $data["end_at"];
            } else {
              $this->end_at = null;
            }
            if (isset($data["break_type_id"])) {
              $this->break_type_id = $data["break_type_id"];
            } else {
              $this->break_type_id = null;
            }
            if (isset($data["name"])) {
              $this->name = $data["name"];
            } else {
              $this->name = null;
            }
            if (isset($data["expected_duration"])) {
              $this->expected_duration = $data["expected_duration"];
            } else {
              $this->expected_duration = null;
            }
            if (isset($data["is_paid"])) {
              $this->is_paid = $data["is_paid"];
            } else {
              $this->is_paid = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id UUID for this object
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets start_at
     * @return string
     */
    public function getStartAt()
    {
        return $this->start_at;
    }
  
    /**
     * Sets start_at
     * @param string $start_at RFC 3339; follows same timezone info as `Shift`. Precision up to the minute is respected; seconds are truncated.
     * @return $this
     */
    public function setStartAt($start_at)
    {
        $this->start_at = $start_at;
        return $this;
    }
    /**
     * Gets end_at
     * @return string
     */
    public function getEndAt()
    {
        return $this->end_at;
    }
  
    /**
     * Sets end_at
     * @param string $end_at RFC 3339; follows same timezone info as `Shift`. Precision up to the minute is respected; seconds are truncated. The `end_at` minute is not counted when the break length is calculated. For example, a break from `00:00` to `00:11`  is considered a 10 minute break (midnight to 10 minutes after midnight).
     * @return $this
     */
    public function setEndAt($end_at)
    {
        $this->end_at = $end_at;
        return $this;
    }
    /**
     * Gets break_type_id
     * @return string
     */
    public function getBreakTypeId()
    {
        return $this->break_type_id;
    }
  
    /**
     * Sets break_type_id
     * @param string $break_type_id The `BreakType` this `Break` was templated on.
     * @return $this
     */
    public function setBreakTypeId($break_type_id)
    {
        $this->break_type_id = $break_type_id;
        return $this;
    }
    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
  
    /**
     * Sets name
     * @param string $name A human-readable name.
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Gets expected_duration
     * @return string
     */
    public function getExpectedDuration()
    {
        return $this->expected_duration;
    }
  
    /**
     * Sets expected_duration
     * @param string $expected_duration Format: RFC-3339 P[n]Y[n]M[n]DT[n]H[n]M[n]S. The expected length of the break.
     * @return $this
     */
    public function setExpectedDuration($expected_duration)
    {
        $this->expected_duration = $expected_duration;
        return $this;
    }
    /**
     * Gets is_paid
     * @return bool
     */
    public function getIsPaid()
    {
        return $this->is_paid;
    }
  
    /**
     * Sets is_paid
     * @param bool $is_paid Whether this break counts towards time worked for compensation purposes.
     * @return $this
     */
    public function setIsPaid($is_paid)
    {
        $this->is_paid = $is_paid;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
