<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * LoyaltyProgramRewardDefinition Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class LoyaltyProgramRewardDefinition implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'scope' => 'string',
        'discount_type' => 'string',
        'percentage_discount' => 'string',
        'catalog_object_ids' => 'string[]',
        'fixed_discount_money' => '\SquareConnect\Model\Money',
        'max_discount_money' => '\SquareConnect\Model\Money'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'scope' => 'scope',
        'discount_type' => 'discount_type',
        'percentage_discount' => 'percentage_discount',
        'catalog_object_ids' => 'catalog_object_ids',
        'fixed_discount_money' => 'fixed_discount_money',
        'max_discount_money' => 'max_discount_money'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'scope' => 'setScope',
        'discount_type' => 'setDiscountType',
        'percentage_discount' => 'setPercentageDiscount',
        'catalog_object_ids' => 'setCatalogObjectIds',
        'fixed_discount_money' => 'setFixedDiscountMoney',
        'max_discount_money' => 'setMaxDiscountMoney'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'scope' => 'getScope',
        'discount_type' => 'getDiscountType',
        'percentage_discount' => 'getPercentageDiscount',
        'catalog_object_ids' => 'getCatalogObjectIds',
        'fixed_discount_money' => 'getFixedDiscountMoney',
        'max_discount_money' => 'getMaxDiscountMoney'
    );
  
    /**
      * $scope Indicates the scope of the reward tier. See [LoyaltyProgramRewardDefinitionScope](#type-loyaltyprogramrewarddefinitionscope) for possible values
      * @var string
      */
    protected $scope;
    /**
      * $discount_type The type of discount the reward tier offers. See [LoyaltyProgramRewardDefinitionType](#type-loyaltyprogramrewarddefinitiontype) for possible values
      * @var string
      */
    protected $discount_type;
    /**
      * $percentage_discount Present if `discount_type` is `FIXED_PERCENTAGE`. For example, a 7.25% off discount will be represented as \"7.25\".
      * @var string
      */
    protected $percentage_discount;
    /**
      * $catalog_object_ids A list of `catalog object` ids to which this reward can be applied. They are either all item-variation ids or category ids, depending on the `type` field.
      * @var string[]
      */
    protected $catalog_object_ids;
    /**
      * $fixed_discount_money Present if `discount_type` is `FIXED_AMOUNT`. For example, $5 off.
      * @var \SquareConnect\Model\Money
      */
    protected $fixed_discount_money;
    /**
      * $max_discount_money When `discount_type` is `FIXED_PERCENTAGE`, the maximum discount amount that can be applied.
      * @var \SquareConnect\Model\Money
      */
    protected $max_discount_money;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["scope"])) {
              $this->scope = $data["scope"];
            } else {
              $this->scope = null;
            }
            if (isset($data["discount_type"])) {
              $this->discount_type = $data["discount_type"];
            } else {
              $this->discount_type = null;
            }
            if (isset($data["percentage_discount"])) {
              $this->percentage_discount = $data["percentage_discount"];
            } else {
              $this->percentage_discount = null;
            }
            if (isset($data["catalog_object_ids"])) {
              $this->catalog_object_ids = $data["catalog_object_ids"];
            } else {
              $this->catalog_object_ids = null;
            }
            if (isset($data["fixed_discount_money"])) {
              $this->fixed_discount_money = $data["fixed_discount_money"];
            } else {
              $this->fixed_discount_money = null;
            }
            if (isset($data["max_discount_money"])) {
              $this->max_discount_money = $data["max_discount_money"];
            } else {
              $this->max_discount_money = null;
            }
        }
    }
    /**
     * Gets scope
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }
  
    /**
     * Sets scope
     * @param string $scope Indicates the scope of the reward tier. See [LoyaltyProgramRewardDefinitionScope](#type-loyaltyprogramrewarddefinitionscope) for possible values
     * @return $this
     */
    public function setScope($scope)
    {
        $this->scope = $scope;
        return $this;
    }
    /**
     * Gets discount_type
     * @return string
     */
    public function getDiscountType()
    {
        return $this->discount_type;
    }
  
    /**
     * Sets discount_type
     * @param string $discount_type The type of discount the reward tier offers. See [LoyaltyProgramRewardDefinitionType](#type-loyaltyprogramrewarddefinitiontype) for possible values
     * @return $this
     */
    public function setDiscountType($discount_type)
    {
        $this->discount_type = $discount_type;
        return $this;
    }
    /**
     * Gets percentage_discount
     * @return string
     */
    public function getPercentageDiscount()
    {
        return $this->percentage_discount;
    }
  
    /**
     * Sets percentage_discount
     * @param string $percentage_discount Present if `discount_type` is `FIXED_PERCENTAGE`. For example, a 7.25% off discount will be represented as \"7.25\".
     * @return $this
     */
    public function setPercentageDiscount($percentage_discount)
    {
        $this->percentage_discount = $percentage_discount;
        return $this;
    }
    /**
     * Gets catalog_object_ids
     * @return string[]
     */
    public function getCatalogObjectIds()
    {
        return $this->catalog_object_ids;
    }
  
    /**
     * Sets catalog_object_ids
     * @param string[] $catalog_object_ids A list of `catalog object` ids to which this reward can be applied. They are either all item-variation ids or category ids, depending on the `type` field.
     * @return $this
     */
    public function setCatalogObjectIds($catalog_object_ids)
    {
        $this->catalog_object_ids = $catalog_object_ids;
        return $this;
    }
    /**
     * Gets fixed_discount_money
     * @return \SquareConnect\Model\Money
     */
    public function getFixedDiscountMoney()
    {
        return $this->fixed_discount_money;
    }
  
    /**
     * Sets fixed_discount_money
     * @param \SquareConnect\Model\Money $fixed_discount_money Present if `discount_type` is `FIXED_AMOUNT`. For example, $5 off.
     * @return $this
     */
    public function setFixedDiscountMoney($fixed_discount_money)
    {
        $this->fixed_discount_money = $fixed_discount_money;
        return $this;
    }
    /**
     * Gets max_discount_money
     * @return \SquareConnect\Model\Money
     */
    public function getMaxDiscountMoney()
    {
        return $this->max_discount_money;
    }
  
    /**
     * Sets max_discount_money
     * @param \SquareConnect\Model\Money $max_discount_money When `discount_type` is `FIXED_PERCENTAGE`, the maximum discount amount that can be applied.
     * @return $this
     */
    public function setMaxDiscountMoney($max_discount_money)
    {
        $this->max_discount_money = $max_discount_money;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
