<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * BusinessHoursPeriod Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 */
class BusinessHoursPeriod implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'day_of_week' => 'string',
        'start_local_time' => 'string',
        'end_local_time' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'day_of_week' => 'day_of_week',
        'start_local_time' => 'start_local_time',
        'end_local_time' => 'end_local_time'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'day_of_week' => 'setDayOfWeek',
        'start_local_time' => 'setStartLocalTime',
        'end_local_time' => 'setEndLocalTime'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'day_of_week' => 'getDayOfWeek',
        'start_local_time' => 'getStartLocalTime',
        'end_local_time' => 'getEndLocalTime'
    );
  
    /**
      * $day_of_week The day of week for this time period. See [DayOfWeek](#type-dayofweek) for possible values
      * @var string
      */
    protected $day_of_week;
    /**
      * $start_local_time The start time of a business hours period, specified in local time using partial-time RFC3339 format.
      * @var string
      */
    protected $start_local_time;
    /**
      * $end_local_time The end time of a business hours period, specified in local time using partial-time RFC3339 format.
      * @var string
      */
    protected $end_local_time;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["day_of_week"])) {
              $this->day_of_week = $data["day_of_week"];
            } else {
              $this->day_of_week = null;
            }
            if (isset($data["start_local_time"])) {
              $this->start_local_time = $data["start_local_time"];
            } else {
              $this->start_local_time = null;
            }
            if (isset($data["end_local_time"])) {
              $this->end_local_time = $data["end_local_time"];
            } else {
              $this->end_local_time = null;
            }
        }
    }
    /**
     * Gets day_of_week
     * @return string
     */
    public function getDayOfWeek()
    {
        return $this->day_of_week;
    }
  
    /**
     * Sets day_of_week
     * @param string $day_of_week The day of week for this time period. See [DayOfWeek](#type-dayofweek) for possible values
     * @return $this
     */
    public function setDayOfWeek($day_of_week)
    {
        $this->day_of_week = $day_of_week;
        return $this;
    }
    /**
     * Gets start_local_time
     * @return string
     */
    public function getStartLocalTime()
    {
        return $this->start_local_time;
    }
  
    /**
     * Sets start_local_time
     * @param string $start_local_time The start time of a business hours period, specified in local time using partial-time RFC3339 format.
     * @return $this
     */
    public function setStartLocalTime($start_local_time)
    {
        $this->start_local_time = $start_local_time;
        return $this;
    }
    /**
     * Gets end_local_time
     * @return string
     */
    public function getEndLocalTime()
    {
        return $this->end_local_time;
    }
  
    /**
     * Sets end_local_time
     * @param string $end_local_time The end time of a business hours period, specified in local time using partial-time RFC3339 format.
     * @return $this
     */
    public function setEndLocalTime($end_local_time)
    {
        $this->end_local_time = $end_local_time;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
