# PaymentRefund

### Description

Represents a refund of a payment made using Square. Contains information on the original payment and the amount of money refunded.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**id** | getId() | setId($value) | **string** | Unique ID for this refund, generated by Square. | 
**status** | getStatus() | setStatus($value) | **string** | The refund&#39;s status: - &#x60;PENDING&#x60; - awaiting approval - &#x60;COMPLETED&#x60; - successfully completed - &#x60;REJECTED&#x60; - the refund was rejected - &#x60;FAILED&#x60; - an error occurred | [optional] 
**location_id** | getLocationId() | setLocationId($value) | **string** | Location ID associated with the payment this refund is attached to. | [optional] 
**amount_money** | getAmountMoney() | setAmountMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The amount of money refunded, specified in the smallest denomination of the applicable currency. For example, US dollar amounts are specified in cents. | 
**app_fee_money** | getAppFeeMoney() | setAppFeeMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | Amount of money the app developer contributed to help cover the refunded amount. Specified in the smallest denomination of the applicable currency. For example, US dollar amounts are specified in cents. See [Working with monetary amounts](https://developer.squareup.com/docs/build-basics/working-with-monetary-amounts) for details. | [optional] 
**processing_fee** | getProcessingFee() | setProcessingFee($value) | [**\SquareConnect\Model\ProcessingFee[]**](ProcessingFee.md) | Processing fees and fee adjustments assessed by Square on this refund. | [optional] 
**payment_id** | getPaymentId() | setPaymentId($value) | **string** | The ID of the payment assocated with this refund. | [optional] 
**order_id** | getOrderId() | setOrderId($value) | **string** | The ID of the order associated with the refund. | [optional] 
**reason** | getReason() | setReason($value) | **string** | The reason for the refund. | [optional] 
**created_at** | getCreatedAt() | setCreatedAt($value) | **string** | Timestamp of when the refund was created, in RFC 3339 format. | [optional] 
**updated_at** | getUpdatedAt() | setUpdatedAt($value) | **string** | Timestamp of when the refund was last updated, in RFC 3339 format. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

