# CatalogObject

### Description

The wrapper object for object types in the Catalog data model. The type of a particular `CatalogObject` is determined by the value of `type` and only the corresponding data field may be set.  - if type = `ITEM`, only `item_data` will be populated and it will contain a valid `CatalogItem` object. - if type = `ITEM_VARIATION`, only `item_variation_data` will be populated and it will contain a valid `CatalogItemVariation` object. - if type = `MODIFIER`, only `modifier_data` will be populated and it will contain a valid `CatalogModifier` object. - if type = `MODIFIER_LIST`, only `modifier_list_data` will be populated and it will contain a valid `CatalogModifierList` object. - if type = `CATEGORY`, only `category_data` will be populated and it will contain a valid `CatalogCategory` object. - if type = `DISCOUNT`, only `discount_data` will be populated and it will contain a valid `CatalogDiscount` object. - if type = `TAX`, only `tax_data` will be populated and it will contain a valid `CatalogTax` object. - if type = `IMAGE`, only `image_data` will be populated and it will contain a valid `CatalogImage` object. - if type = `QUICK_AMOUNTS_SETTINGS`, only `quick_amounts_settings_data` will be populated and will contain a valid `CatalogQuickAmountsSettings` object.  For a more detailed discussion of the Catalog data model, please see the [Design a Catalog](/catalog-api/design-a-catalog) guide.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**type** | getType() | setType($value) | **string** | The type of this object. Each object type has expected properties expressed in a structured format within its corresponding &#x60;*_data&#x60; field below. See [CatalogObjectType](#type-catalogobjecttype) for possible values | 
**id** | getId() | setId($value) | **string** | An identifier to reference this object in the catalog. When a new &#x60;CatalogObject&#x60; is inserted, the client should set the id to a temporary identifier starting with a \&quot;&#x60;#&#x60;\&quot; character. Other objects being inserted or updated within the same request may use this identifier to refer to the new object.  When the server receives the new object, it will supply a unique identifier that replaces the temporary identifier for all future references. | 
**updated_at** | getUpdatedAt() | setUpdatedAt($value) | **string** | Last modification [timestamp](https://developer.squareup.com/docs/build-basics/working-with-dates) in RFC 3339 format, e.g., &#x60;\&quot;2016-08-15T23:59:33.123Z\&quot;&#x60; would indicate the UTC time (denoted by &#x60;Z&#x60;) of August 15, 2016 at 23:59:33 and 123 milliseconds. | [optional] 
**version** | getVersion() | setVersion($value) | **int** | The version of the object. When updating an object, the version supplied must match the version in the database, otherwise the write will be rejected as conflicting. | [optional] 
**is_deleted** | getIsDeleted() | setIsDeleted($value) | **bool** | If &#x60;true&#x60;, the object has been deleted from the database. Must be &#x60;false&#x60; for new objects being inserted. When deleted, the &#x60;updated_at&#x60; field will equal the deletion time. | [optional] 
**custom_attribute_values** | getCustomAttributeValues() | setCustomAttributeValues($value) | [**map[string,\SquareConnect\Model\CatalogCustomAttributeValue]**](CatalogCustomAttributeValue.md) | Application-defined key/value attributes that are set at a global (location-independent) level. Custom Attribute Values are intended to store additional information about a Catalog Object or associations with an entity in another system. Do not use custom attributes to store any sensitive information (personally identifiable information, card details, etc.).  For CustomAttributesDefinitions defined by the app making the request, the map key is the key defined in the &#x60;CatalogCustomAttributeDefinition&#x60; (e.g. “reference_id”). For custom attributes created by other apps, the map key is the key defined in &#x60;CatalogCustomAttributeDefinition&#x60; prefixed with the application ID and a colon (eg. “abcd1234:reference_id”). | [optional] [beta]
**catalog_v1_ids** | getCatalogV1Ids() | setCatalogV1Ids($value) | [**\SquareConnect\Model\CatalogV1Id[]**](CatalogV1Id.md) | The Connect v1 IDs for this object at each location where it is present, where they differ from the object&#39;s Connect V2 ID. The field will only be present for objects that have been created or modified by legacy APIs. | [optional] 
**present_at_all_locations** | getPresentAtAllLocations() | setPresentAtAllLocations($value) | **bool** | If &#x60;true&#x60;, this object is present at all locations (including future locations), except where specified in the &#x60;absent_at_location_ids&#x60; field. If &#x60;false&#x60;, this object is not present at any locations (including future locations), except where specified in the &#x60;present_at_location_ids&#x60; field. If not specified, defaults to &#x60;true&#x60;. | [optional] 
**present_at_location_ids** | getPresentAtLocationIds() | setPresentAtLocationIds($value) | **string[]** | A list of locations where the object is present, even if &#x60;present_at_all_locations&#x60; is &#x60;false&#x60;. | [optional] 
**absent_at_location_ids** | getAbsentAtLocationIds() | setAbsentAtLocationIds($value) | **string[]** | A list of locations where the object is not present, even if &#x60;present_at_all_locations&#x60; is &#x60;true&#x60;. | [optional] 
**image_id** | getImageId() | setImageId($value) | **string** | Identifies the &#x60;CatalogImage&#x60; attached to this &#x60;CatalogObject&#x60;. | [optional] 
**item_data** | getItemData() | setItemData($value) | [**\SquareConnect\Model\CatalogItem**](CatalogItem.md) | Structured data for a &#x60;CatalogItem&#x60;, set for CatalogObjects of type &#x60;ITEM&#x60;. | [optional] 
**category_data** | getCategoryData() | setCategoryData($value) | [**\SquareConnect\Model\CatalogCategory**](CatalogCategory.md) | Structured data for a &#x60;CatalogCategory&#x60;, set for CatalogObjects of type &#x60;CATEGORY&#x60;. | [optional] 
**item_variation_data** | getItemVariationData() | setItemVariationData($value) | [**\SquareConnect\Model\CatalogItemVariation**](CatalogItemVariation.md) | Structured data for a &#x60;CatalogItemVariation&#x60;, set for CatalogObjects of type &#x60;ITEM_VARIATION&#x60;. | [optional] 
**tax_data** | getTaxData() | setTaxData($value) | [**\SquareConnect\Model\CatalogTax**](CatalogTax.md) | Structured data for a &#x60;CatalogTax&#x60;, set for CatalogObjects of type &#x60;TAX&#x60;. | [optional] 
**discount_data** | getDiscountData() | setDiscountData($value) | [**\SquareConnect\Model\CatalogDiscount**](CatalogDiscount.md) | Structured data for a &#x60;CatalogDiscount&#x60;, set for CatalogObjects of type &#x60;DISCOUNT&#x60;. | [optional] 
**modifier_list_data** | getModifierListData() | setModifierListData($value) | [**\SquareConnect\Model\CatalogModifierList**](CatalogModifierList.md) | Structured data for a &#x60;CatalogModifierList&#x60;, set for CatalogObjects of type &#x60;MODIFIER_LIST&#x60;. | [optional] 
**modifier_data** | getModifierData() | setModifierData($value) | [**\SquareConnect\Model\CatalogModifier**](CatalogModifier.md) | Structured data for a &#x60;CatalogModifier&#x60;, set for CatalogObjects of type &#x60;MODIFIER&#x60;. | [optional] 
**time_period_data** | getTimePeriodData() | setTimePeriodData($value) | [**\SquareConnect\Model\CatalogTimePeriod**](CatalogTimePeriod.md) | Structured data for a &#x60;CatalogTimePeriod&#x60;, set for CatalogObjects of type &#x60;TIME_PERIOD&#x60;. | [optional] 
**product_set_data** | getProductSetData() | setProductSetData($value) | [**\SquareConnect\Model\CatalogProductSet**](CatalogProductSet.md) | Structured data for a &#x60;CatalogProductSet&#x60;, set for CatalogObjects of type &#x60;PRODUCT_SET&#x60;. | [optional] 
**pricing_rule_data** | getPricingRuleData() | setPricingRuleData($value) | [**\SquareConnect\Model\CatalogPricingRule**](CatalogPricingRule.md) | Structured data for a &#x60;CatalogPricingRule&#x60;, set for CatalogObjects of type &#x60;PRICING_RULE&#x60;. | [optional] 
**image_data** | getImageData() | setImageData($value) | [**\SquareConnect\Model\CatalogImage**](CatalogImage.md) | Structured data for a &#x60;CatalogImage&#x60;, set for CatalogObjects of type &#x60;IMAGE&#x60;. | [optional] 
**measurement_unit_data** | getMeasurementUnitData() | setMeasurementUnitData($value) | [**\SquareConnect\Model\CatalogMeasurementUnit**](CatalogMeasurementUnit.md) | Structured data for a &#x60;CatalogMeasurementUnit&#x60;, set for CatalogObjects of type &#x60;MEASUREMENT_UNIT&#x60;. | [optional] 
**item_option_data** | getItemOptionData() | setItemOptionData($value) | [**\SquareConnect\Model\CatalogItemOption**](CatalogItemOption.md) | Structured data for a &#x60;CatalogItemOption&#x60;, set for CatalogObjects of type &#x60;ITEM_OPTION&#x60;. | [optional] 
**item_option_value_data** | getItemOptionValueData() | setItemOptionValueData($value) | [**\SquareConnect\Model\CatalogItemOptionValue**](CatalogItemOptionValue.md) | Structured data for a &#x60;CatalogItemOptionValue&#x60;, set for CatalogObjects of type &#x60;ITEM_OPTION_VAL&#x60;. | [optional] 
**custom_attribute_definition_data** | getCustomAttributeDefinitionData() | setCustomAttributeDefinitionData($value) | [**\SquareConnect\Model\CatalogCustomAttributeDefinition**](CatalogCustomAttributeDefinition.md) | Structured data for a &#x60;CatalogCustomAttributeDefinition&#x60;, set for CatalogObjects of type &#x60;CUSTOM_ATTRIBUTE_DEFINITION&#x60;. | [optional] 
**quick_amounts_settings_data** | getQuickAmountsSettingsData() | setQuickAmountsSettingsData($value) | [**\SquareConnect\Model\CatalogQuickAmountsSettings**](CatalogQuickAmountsSettings.md) | Structured data for a &#x60;CatalogQuickAmountsSettings&#x60;, set for CatalogObjects of type &#x60;QUICK_AMOUNTS_SETTINGS&#x60;. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

